// Liczba sw.  Uycie: java Wc nazwa_pliku
// Wywietla w kolejnych wierszach kade sowo wystpujce w pliku.
// Kolejnym krokiem jest wywietlenie liczby sw.
// Sowo to dowolna sekwencja liter rozdzielonych innych znakami.

import java.io.*;

class Wc {
  public static void main(String argv[]) {

    // Otwarcie pliku wejciowego, zgoszenie bdw
    try {

      // Otwarcie pliku wejciowego
      InputStream f=new FileInputStream(argv[0]);

      // Liczba sw
      int c;  // Aktualny znak
      boolean last_char_was_letter=false;  // Typ wczeniejszego znak
      int count=0;  // Number of words
      while ((c=f.read())>=0) {  // A do osignicia -1 (EOF)
        if (Character.isLetter((char)c)) {
          c=Character.toUpperCase((char)c);
          if (!last_char_was_letter) {
            last_char_was_letter=true;
            ++count;
          }
          // System.out.write(c);
        }
        else if (last_char_was_letter) {
          last_char_was_letter=false;
          // System.out.write('\n');
        }
      }

      // Wywietlenie wyniku
      System.out.println(argv[0]+" ma "+count+" sw");

      // Zamknicie pliku
      f.close();

    }
    catch(FileNotFoundException x) {
      System.out.println("Nie odnaleziono pliku: "+argv[0]);
    }
    catch(ArrayIndexOutOfBoundsException x) {  // for argv
      System.out.println("Uycie: java Wc nazwa_pliku");
    }
    catch(IOException x) {  // Obsuga innych wyjtkw
      System.out.println(""+x);
    }
  }
}

